/*
 *	File: applib.r
 *	
 *  Description: Common resource definitons for all sample programs.
 *               Some of these definitions are derived from the example
 *               resource files supplied with the MPW C++ compiler; the rest
 *               were created by using ResEdit and the mpw tool derez.
 */
 

#include "SysTypes.r"
#include "Types.r"

#include "apcommon.h"


/* we use an MBAR resource to conveniently load all the menus */

resource 'MBAR' (rMenuBar, preload) {
	{ mApple, mFile, mApp };		/* three menus */
};


resource 'MENU' (mApple, preload) {
	mApple, textMenuProc,
	0b1111111111111111111111111111101,	/* disable dashed line, enable About and DAs */
	enabled, apple,
	{
		"About C++App.",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};
resource 'MENU' (mFile, preload) {
	mFile, textMenuProc,
	0b1111111111111111111111111111111,	/* enable Quit only, program enables others */
	enabled, "File",
	{
		
		"Quit",
		noicon, "Q", nomark, plain
	}
};

resource 'vers' (1) {
	0x01, 0x00, release, 0x00,
	verUS,
	"1.00",
	"1.00, Copyright c 1991 by Mark Watson Associates"
};

resource 'SIZE' (-1) {
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,
	multiFinderAware,	/* this says we do our own activate/deactivate; don't fake us out */
	backgroundAndForeground, /* this is definitely note a background-only application! */
	dontGetFrontClicks,	/* change this is if you want "do first click" behavior like the Finder */
	ignoreChildDiedEvents,
	is32BitCompatible,
	reserved, reserved, reserved, reserved,
	reserved, reserved, reserved,
	kPrefSize * 1024,
	kMinSize * 1024
};


type 'MLW1' as 'STR ';


resource 'MLW1' (0) {
	"GUI Library based C++ Application"
};


resource 'BNDL' (128) {
	'MLW1',
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};


resource 'ICN#' (128) {
	{ /* array: 2 elements */
		/* [1] */
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 01 C0 00" 
	$"00 03 40 00 00 05 C0 00 00 08 00 00 00 10 00 00" 
	$"00 E0 00 00 01 A0 00 00 02 E0 00 00 04 10 00 00"
	$"08 08 00 00 70 05 C1 C0 50 03 7F 40 70 01 C1 C0" 
	$"08 00 00 00 04 00 00 00 02 E1 C0 00 01 BF 40 00" 
	$"00 E1 C0 00 00 00 00 00 00 00 00 00 10 48 02 20" 
	$"18 C8 02 50 15 44 04 50 12 44 44 88 10 42 A8 F8" 
	$"10 42 A9 04 10 41 11 04 00 00 00 00 00 00 00 00"  
	}
};

data 'DITL' (501, purgeable) {
	$"0003 0000 0000 00DC 0133 00FC 0186 0402"
	$"4F4B 0000 0000 00DC 0193 00FC 01EA 0406"
	$"4361 6E63 656C 0000 0000 0025 0009 00D9"
	$"01ED 101A 6E65 7720 7465 7874 2064 6573"
	$"6372 6970 7469 6F6E 2062 6C6F 636B 0000"
	$"0000 0002 0009 0019 01EA 0806 5072 6F6D"
	$"7074"
};

data 'DLOG' (501, purgeable) {
	$"0042 0008 0143 01F7 0003 0100 0000 0000"
	$"0000 01F5 1445 6E74 6572 206E 6577 206E"
	$"6F64 6520 7469 746C 65"
};

data 'DLOG' (511) {
	$"0029 0039 0148 018C 0000 0100 0100 0000"
	$"0000 01FF 00"
};

data 'DITL' (511) {
	$"0002 0000 0000 0107 0116 011B 0150 0406" 
	$"4361 6E63 656C 0000 0000 0004 0005 0019"
	$"015A 8813 5072 6F6D 7074 2067 6F65 7320"
	$"6865 7265 2E2E 2E00 0000 0000 0024 0007"
	$"00F6 0138 8000"
};

data 'DLOG' (515) {
	$"0028 0028 0093 01A0 0000 0100 0100 0000"
	$"0000 0203 00"
};

data 'DITL' (515) {
	$"0001 0000 0000 000A 0008 002D 0172 040B"
	$"4F70 7469 6F6E 2031 2E2E 2E00 0000 0000"
	$"0035 0009 005A 0171 040B 4F70 7469 6F6E"
	$"2032 2E2E 2E00"
};

data 'DLOG' (128) {
	$"0041 003E 0127 01C7 0001 0100 0000 0000"
	$"0000 0080 00" 
};
/* these ALRT and DITL are used for 'show info' */

resource 'ALRT' (128, purgeable) {
	{40, 20, 160, 330 }, rAboutAlert, {
		OK, visible, silent;
		OK, visible, silent;
		OK, visible, silent;
		OK, visible, silent
	};
};

resource 'DITL' (128, purgeable) {
	{ 
		{88, 224, 108, 304},
		Button { enabled, "OK" },
		{8, 8, 24, 304 },
		StaticText { disabled, "C++App Class" },
		{32, 8, 48, 237},
		StaticText { disabled, "Copyright c 1991 by Mark Watson" },
		{56, 8, 72, 156},
		StaticText { disabled, "    " },
		{80, 24, 112, 167},
		StaticText { disabled, "Better AI software..." }
	}
};

data 'DLOG' (129) {
	$"004B 005C 010E 01B9 0001 0100 0000 0000" 
	$"0000 0081 00"                            
};

resource 'ALRT' (129, purgeable) {
	{40, 20, 150, 260},
	129,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	}
};

/* specify the desired window type: */
resource 'WIND' (rDocWindow, preload, purgeable) {
	{64, 60, 520, 520},
	rDocProc, invisible,nogoaway, 0x0, "C++ GUI Library Test Program"
};
